//
//  WXKSchedule.m
//  Kyopon Schedule Sync
//
//  Created by 藤波 想 on 06/09/18.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "WXKSchedule.h"


@implementation WXKSchedule

- (NSData *)vCalendarRepresentation
{
	NSMutableString *string = [NSMutableString string];
	id value;
	
	// header
	[string appendString:@"BEGIN:VCALENDAR\r\n" @"VERSION:1.0\r\n" @"BEGIN:VEVENT\r\n"];
	
	// summary (SUMMARY:)
	if ((value = [self valueForKey:@"summary"]) != nil) {
		[string appendFormat:@"SUMMARY:%@\r\n", value];
	}
	
	// categories (CATEGORIES:, X-WX310K-CATEGORIES:) 
//	if ((value = [self valueForKey:@"categories"]) != nil) {
//		[string appendFormat:@"CATEGORIES:%@\r\n", value];
//		[string appendFormat:@"X-WX310K-CATEGORIES:%@\r\n", value];
//	}
	
	// start date (DTSTART:20060930T120000Z). WX310K does not accept the format such as "20040908"
	if ((value = [self valueForKey:@"startDate"]) != nil) {
		NSTimeZone *timeZone = [NSTimeZone timeZoneForSecondsFromGMT:0];
		
		if ([[self valueForKey:@"allDay"] boolValue]) {
			// All day events in the truth database start with 12:00 (GMT) and end with 12:00 (GMT) on next day,
			// but all day events in WX310K should start with 0:00 (JST) and end with 0:00 (JST) on next day.
			value = [value addTimeInterval:(- 21 * 60 * 60)];
		}
		
		[string appendFormat:@"DTSTART:%@\r\n", [value descriptionWithCalendarFormat:@"%Y%m%dT%H%M%SZ" timeZone:timeZone locale:nil]];
	}
	
	if ((value = [self valueForKey:@"endDate"]) != nil) {
		NSTimeZone *timeZone = [NSTimeZone timeZoneForSecondsFromGMT:0];
		
		if ([[self valueForKey:@"allDay"] boolValue]) {
			// All day events in the truth database start with 12:00 (GMT) and end with 12:00 (GMT) on next day,
			// but all day events in WX310K should start with 0:00 (JST) and end with 0:00 (JST) on next day.
			value = [value addTimeInterval:(- 21 * 60 * 60)];
		}
		
		[string appendFormat:@"DTEND:%@\r\n", [value descriptionWithCalendarFormat:@"%Y%m%dT%H%M%SZ" timeZone:timeZone locale:nil]];
	}
	
	// alarm 
//	if ((value = [self valueForKey:@"endDate"]) != nil) {
//		[string appendFormat:@"DTEND:%@\r\n", value];
//	}
	
	// location
	if ((value = [self valueForKey:@"location"]) != nil) {
		[string appendFormat:@"LOCATION:%@\r\n", value];
	}
	
	// description
	if ((value = [self valueForKey:@"details"]) != nil) {
		[string appendFormat:@"DESCRIPTION:%@\r\n", value];
	}
	
	// URL
	if ((value = [self valueForKey:@"urlString"]) != nil) {
		[string appendFormat:@"URL:%@\r\n", value];
	}
	
	// classification (CLASS: PRIVATE or PUBLIC)
	if ((value = [self valueForKey:@"classification"]) != nil) {
		[string appendFormat:@"CLASS:%@\r\n", [value uppercaseString]];
	} else {
		[string appendFormat:@"CLASS:PUBLIC\r\n"];
	}
	
	// footer
	[string appendString:@"END:VEVENT\r\n" @"END:VCALENDAR\r\n"];
	
	return [string dataUsingEncoding:NSShiftJISStringEncoding allowLossyConversion:YES];
}


@end
